﻿if (typeof (MCS) == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;

if (typeof (MCS.ParticipatingSite) == "undefined") {
    MCS.ParticipatingSite = {};
}

//Page level variables
MCS.ParticipatingSite.Site = [];

MCS.ParticipatingSite.EntityId = null;
MCS.ParticipatingSite.PSName = null;
MCS.ParticipatingSite.Side = null;
MCS.ParticipatingSite.Group = false;
MCS.ParticipatingSite.Modality = null;

MCS.ParticipatingSite.OnLoad = function () {
    MCS.ParticipatingSite.OnlyProviderHM();

    if (Xrm.Page.ui.getFormType() != 1) {
        Xrm.Page.getControl("cvt_resourcepackage").setDisabled(true);
        Xrm.Page.getControl("cvt_site").setDisabled(true);
        Xrm.Page.getControl("cvt_locationtype").setDisabled(true);
        Xrm.Page.getControl("cvt_scheduleable").setDisabled(false);

        //Get the values for the ribbon
        MCS.ParticipatingSite.EntityId = Xrm.Page.data.entity.getId();
        MCS.ParticipatingSite.PSName = Xrm.Page.getAttribute("cvt_name").getValue();
        MCS.ParticipatingSite.Side = (Xrm.Page.getAttribute("cvt_locationtype").getValue() == 917290000) ? "Provider" : "Patient";

        if (Xrm.Page.getAttribute("cvt_site").getValue() != null) {
            MCS.ParticipatingSite.Site = Xrm.Page.getAttribute("cvt_site").getValue()
        }
    }
    else {
        Xrm.Page.getControl("cvt_scheduleable").setDisabled(true);
    }
};

MCS.ParticipatingSite.ChooseSite = function () {
    //Make the SOS field visible and get the url
    if (Xrm.Page.getAttribute("cvt_site").getValue() != null) {
        var calls = CrmRestKit.Retrieve("mcs_site", Xrm.Page.getAttribute("cvt_site").getValue()[0].id, ['mcs_FacilityId'], false);
        calls.fail(
                function (error) {
                }).done(function (data) {
                    if (data && data.d && data.d.mcs_FacilityId != null) {
                        var lookup = new Array();
                        lookup[0] = new Object();
                        lookup[0].id = data.d.mcs_FacilityId.Id;
                        lookup[0].name = data.d.mcs_FacilityId.Name;
                        lookup[0].entityType = "mcs_facility";
                        Xrm.Page.getAttribute("cvt_facility").setValue(lookup)
                        Xrm.Page.getAttribute("cvt_facility").setSubmitMode("always");
                    }
                });
    }
    else
    {
        //clear out Facility field
        //save
        if (Xrm.Page.getAttribute("cvt_facility").getValue() != null) {
            Xrm.Page.getAttribute("cvt_facility").setValue(null)
        }
    }
};

MCS.ParticipatingSite.CreateName = function () {
    var derivedResultField = "";

    var site = Xrm.Page.getAttribute("cvt_site").getValue();
    var locationType = Xrm.Page.getAttribute("cvt_locationtype").getValue();

    var siteName = "";
    var locationText = "";

    if (site != null)
        siteName = site[0].name;


    if (locationType != null) {
        switch (locationType) {
            case 917290000:
                locationText += "Pro";
                break;
            case 917290001:
                locationText += "Pat";
                break;
        }
    }

    derivedResultField = locationText + " - " + siteName;

    if (Xrm.Page.getAttribute("cvt_name").getValue() != derivedResultField) {
        Xrm.Page.getAttribute("cvt_name").setSubmitMode("always");
        Xrm.Page.getAttribute("cvt_name").setValue(derivedResultField);
    }
};

MCS.ParticipatingSite.OnlyProviderHM = function () {
    //Make the SOS field visible and get the url
    if (Xrm.Page.getAttribute("cvt_resourcepackage").getValue() != null) {
        var calls = CrmRestKit.Retrieve("cvt_resourcepackage", Xrm.Page.getAttribute("cvt_resourcepackage").getValue()[0].id, ['cvt_patientlocationtype', 'cvt_availabletelehealthmodality', 'cvt_groupappointment'], false);
        calls.fail(
                function (error) {
                }).done(function (data) {
                    if (data && data.d) {
                        if (data.d.cvt_patientlocationtype != null) {
                            if (data.d.cvt_patientlocationtype.Value == 917290001) {
                                //RP is H/M only Provider Site allowed.
                                //Display note at top of screen and default location type
                                Xrm.Page.getAttribute("cvt_locationtype").setValue(917290000)
                                Xrm.Page.getControl("cvt_locationtype").setDisabled(true);
                                MCS.cvt_Common.Notifications("Add", 3, "Only Provider Sites can be added to a VA Video Connect Resource Package.");
                            }
                            else {
                                Xrm.Page.getControl("cvt_locationtype").setDisabled(false);
                                MCS.cvt_Common.Notifications("Hide");
                            }
                        }
                        MCS.ParticipatingSite.Group = data.d.cvt_groupappointment;

                        if (data.d.cvt_availabletelehealthmodality) {
                            if (data.d.cvt_availabletelehealthmodality.Value == 917290000)
                                MCS.ParticipatingSite.Modality = "CVT";
                            else
                                MCS.ParticipatingSite.Modality = "SFT";
                        }
                    }
                });
    }
};